# Парсер контента

Модуль для парсинга внешнего контента с веб-сайтов. Поддерживает пагинацию, извлечение изображений и сохранение в базу данных.

## Возможности

- ✅ Парсинг контента с внешних сайтов
- ✅ Поддержка пагинации (например, `/page/{page}` или `?page={page}`)
- ✅ Извлечение заголовков, контента и изображений
- ✅ Сохранение изображений в локальную папку
- ✅ Асинхронное выполнение через очереди
- ✅ Веб-интерфейс для управления
- ✅ Тестирование селекторов
- ✅ Экспорт результатов в JSON
- ✅ Отслеживание прогресса парсинга

## Установка

1. Установите зависимости:
```bash
composer require symfony/dom-crawler symfony/css-selector guzzlehttp/guzzle intervention/image
```

2. Запустите миграции:
```bash
php artisan migrate
```

3. Создайте символическую ссылку для storage:
```bash
php artisan storage:link
```

## Использование

### Веб-интерфейс

1. Перейдите в админ панель: `/admin/parser`
2. Создайте новую задачу парсинга
3. Укажите настройки:
   - **Название задачи** - для идентификации
   - **Базовый URL** - главная страница для парсинга
   - **Шаблон пагинации** - например `/page/{page}` или `?page={page}`
   - **Диапазон страниц** - от и до
   - **CSS селекторы** для извлечения данных

### CSS селекторы

- **Посты** - селектор для контейнера каждого поста (например, `.post`, `article`)
- **Заголовки** - селектор для заголовков (например, `h1`, `.title`)
- **Контент** - селектор для содержимого (например, `.content`, `p`)
- **Изображения** - селектор для изображений (например, `img`, `.image`)
- **Ссылки** - селектор для ссылок (например, `a`, `.link`)

### Примеры селекторов

#### Для блога WordPress:
```json
{
  "posts": "article",
  "titles": "h2.entry-title a",
  "content": ".entry-content",
  "images": ".entry-content img",
  "links": "h2.entry-title a"
}
```

#### Для новостного сайта:
```json
{
  "posts": ".news-item",
  "titles": ".news-title",
  "content": ".news-excerpt",
  "images": ".news-image img",
  "links": ".news-title a"
}
```

### API Endpoints

Все эндпоинты требуют авторизации и права администратора:

#### Создание задачи
```http
POST /api/v1/parser/jobs
```

#### Получение списка задач
```http
GET /api/v1/parser/jobs
```

#### Запуск парсинга
```http
POST /api/v1/parser/jobs/{id}/start
```

#### Остановка парсинга
```http
POST /api/v1/parser/jobs/{id}/stop
```

#### Получение прогресса
```http
GET /api/v1/parser/jobs/{id}/progress
```

#### Тестирование селекторов
```http
POST /api/v1/parser/test-selectors
```

#### Экспорт результатов
```http
GET /api/v1/parser/jobs/{id}/export
```

### Командная строка

#### Тестирование селекторов:
```bash
php artisan parser:test "https://example.com" --selectors='{"posts":".post","titles":"h2","content":".content"}'
```

## Структура базы данных

### Таблица `parser_jobs`
- `id` - ID задачи
- `name` - Название задачи
- `base_url` - Базовый URL для парсинга
- `pagination_pattern` - Шаблон пагинации
- `start_page` - Начальная страница
- `end_page` - Конечная страница
- `post_selector` - CSS селектор постов
- `title_selector` - CSS селектор заголовков
- `content_selector` - CSS селектор контента
- `image_selector` - CSS селектор изображений
- `link_selector` - CSS селектор ссылок
- `status` - Статус (pending, running, completed, failed)
- `total_posts` - Общее количество найденных постов
- `parsed_posts` - Количество обработанных постов
- `error_message` - Сообщение об ошибке
- `settings` - Дополнительные настройки (JSON)

### Таблица `parsed_posts`
- `id` - ID поста
- `parser_job_id` - ID задачи парсинга
- `title` - Заголовок поста
- `content` - Содержимое поста
- `original_url` - Оригинальная ссылка
- `image_path` - Путь к сохраненному изображению
- `image_url` - Оригинальная ссылка на изображение
- `page_number` - Номер страницы
- `metadata` - Дополнительные метаданные (JSON)

## Настройка очередей

Для асинхронного выполнения парсинга настройте очереди:

1. Настройте драйвер очередей в `.env`:
```env
QUEUE_CONNECTION=database
```

2. Создайте таблицу очередей:
```bash
php artisan queue:table
php artisan migrate
```

3. Запустите обработчик очередей:
```bash
php artisan queue:work
```

## Безопасность

- Все эндпоинты защищены авторизацией
- Требуются права администратора
- Валидация всех входных данных
- Ограничение времени выполнения (1 час)
- User-Agent для имитации браузера

## Ограничения

- Таймаут запросов: 30 секунд
- Максимальное время выполнения задачи: 1 час
- Изображения сохраняются в форматах: JPG, PNG, GIF, WebP
- Поддерживается только HTTP/HTTPS

## Troubleshooting

### Ошибка "cURL error 28: Operation timed out"
- Увеличьте таймаут в `ParserService`
- Проверьте доступность сайта

### Ошибка "Invalid selector"
- Проверьте правильность CSS селекторов
- Используйте инструменты разработчика браузера

### Ошибка "Permission denied" при сохранении изображений
- Проверьте права на папку `storage/app/public/parsed_images`
- Убедитесь, что символическая ссылка создана

### Медленная работа
- Увеличьте задержку между запросами в `ParserService`
- Используйте более мощный сервер
- Настройте кэширование

## Примеры использования

### Парсинг блога с пагинацией
```json
{
  "name": "Парсинг блога",
  "base_url": "https://blog.example.com",
  "pagination_pattern": "/page/{page}",
  "start_page": 1,
  "end_page": 10,
  "post_selector": "article.post",
  "title_selector": "h2.post-title a",
  "content_selector": ".post-excerpt",
  "image_selector": ".post-thumbnail img",
  "link_selector": "h2.post-title a"
}
```

### Парсинг новостного сайта
```json
{
  "name": "Новости",
  "base_url": "https://news.example.com",
  "pagination_pattern": "?page={page}",
  "start_page": 1,
  "end_page": 5,
  "post_selector": ".news-item",
  "title_selector": ".news-title",
  "content_selector": ".news-summary",
  "image_selector": ".news-image img"
}
``` 