# 🚀 Promo Platform Laravel

Платформа для промокодов и предсказаний с мессенджером.

## ⚡ Быстрый старт

### 1. Автоматическая установка (Windows)
```bash
install.bat
```

### 2. Ручная установка
```bash
# Зависимости
composer install
npm install

# Окружение
cp .env.example .env
php artisan key:generate

# База данных
touch database/database.sqlite
php artisan migrate --seed
```

### 3. Запуск
```bash
# Разработка (Laravel + Vite)
php artisan dev

# Production (собранные assets)
npm run build && php artisan prod

# Простой запуск (только Laravel)
php artisan serve:simple

# С batch файлами (Windows)
start-simple.bat
```

## 📋 Основные команды

```bash
# Запуск серверов
php artisan dev                  # Разработка (Laravel + Vite)
php artisan prod                 # Production (собранные assets)
php artisan serve:simple         # Только Laravel

# Работа с базой данных
php artisan migrate               # Миграции
php artisan db:seed              # Тестовые данные
php artisan migrate:fresh --seed # Сброс + данные

# Сборка assets
npm run build                    # Production
npm run dev                      # Development
```

## 🔑 Тестовые аккаунты

**Админ:**
- Email: admin@example.com
- Пароль: password

**Пользователь:**
- Email: user@example.com
- Пароль: password

## 📁 Структура проекта

```
├── app/                    # PHP код
├── resources/js/          # Vue.js компоненты
├── database/              # Миграции и сиды
├── routes/                # API маршруты
└── public/                # Публичные файлы
```

## 🛠️ Требования

- PHP 8.2+
- Node.js 16+
- Composer
- SQLite (или MySQL/PostgreSQL)

## 📖 Документация

- [Установка](INSTALL.md) - Подробная инструкция
- [Команды запуска](SERVE_COMMANDS.md) - Все команды серверов
- [WebSocket настройка](WEBSOCKET_SETUP.md) - Настройка чата

## 🆘 Поддержка

Если что-то не работает:
1. Проверьте версии: PHP 8.2+, Node.js 16+
2. Убедитесь что все зависимости установлены
3. Проверьте настройки в .env файле
4. Посмотрите логи: `storage/logs/laravel.log`

## 📱 Основные функции

### Для пользователей:
- 📋 Просмотр каталога букмекеров
- 🎫 Поиск и использование промо-кодов
- 📊 Система прогнозов
- 👥 Реферальная программа
- 🏆 Система очков и рейтингов

### Для администраторов:
- 👤 Управление пользователями
- 🏢 Управление букмекерами
- 🎫 Управление промо-кодами
- 📊 Статистика и аналитика
- ⚙️ Настройки системы

## 🗂️ Структура проекта

```
promo-platform-laravel/
├── app/
│   ├── Http/Controllers/Api/     # API контроллеры
│   ├── Models/                   # Eloquent модели
│   └── Providers/               # Сервис провайдеры
├── database/
│   ├── migrations/              # Миграции БД
│   └── seeders/                 # Сидеры данных
├── resources/
│   ├── js/
│   │   ├── components/          # Vue компоненты
│   │   ├── layouts/             # Макеты страниц
│   │   └── app.js              # Главный JS файл
│   └── views/                   # Blade шаблоны
├── routes/
│   └── api.php                 # API маршруты
└── public/                     # Публичные файлы
```

## 🔧 API Endpoints

### Аутентификация
- `POST /api/v1/register` - Регистрация
- `POST /api/v1/login` - Вход
- `POST /api/v1/logout` - Выход

### Букмекеры
- `GET /api/v1/bookmakers` - Список букмекеров
- `GET /api/v1/bookmakers/{slug}` - Детали букмекера
- `GET /api/v1/bookmakers/featured` - Популярные букмекеры

### Промо-коды
- `GET /api/v1/promo-codes` - Список промо-кодов
- `POST /api/v1/promo-codes/use` - Использовать промо-код
- `GET /api/v1/promo-codes/{id}` - Детали промо-кода

### Пользователи
- `GET /api/v1/user/profile` - Профиль пользователя
- `PUT /api/v1/user/profile` - Обновить профиль
- `GET /api/v1/leaderboard` - Таблица лидеров

### Админ панель
- `GET /api/v1/admin/dashboard` - Дашборд
- `GET /api/v1/admin/users` - Управление пользователями
- `GET /api/v1/admin/bookmakers` - Управление букмекерами
- `GET /api/v1/admin/promo-codes` - Управление промо-кодами

## 🎨 Компоненты Vue.js

### Основные страницы:
- `Home.vue` - Главная страница
- `Bookmakers.vue` - Каталог букмекеров
- `PromoCodes.vue` - Промо-коды
- `Predictions.vue` - Прогнозы
- `Profile.vue` - Профиль пользователя

### Аутентификация:
- `Auth/Login.vue` - Страница входа
- `Auth/Register.vue` - Страница регистрации

### Админ панель:
- `Admin/Dashboard.vue` - Дашборд админа
- `Admin/Users.vue` - Управление пользователями
- `Admin/Bookmakers.vue` - Управление букмекерами
- `Admin/PromoCodes.vue` - Управление промо-кодами

### Макеты:
- `MainLayout.vue` - Основной макет
- `AdminLayout.vue` - Макет админ панели

## 🔐 Безопасность

- CSRF защита для всех форм
- Sanctum аутентификация для API
- Валидация всех входных данных
- Защита от SQL инъекций
- XSS защита

## 📈 Производительность

- Кэширование запросов к БД
- Оптимизация изображений
- Минификация CSS/JS
- Lazy loading компонентов
- CDN для статических файлов

## 🤝 Разработка

### Добавление нового компонента:

1. Создайте файл в `resources/js/components/`
2. Добавьте роут в `resources/js/app.js`
3. Обновите навигацию при необходимости

### Добавление нового API endpoint:

1. Создайте контроллер в `app/Http/Controllers/Api/`
2. Добавьте роут в `routes/api.php`
3. Создайте миграцию при необходимости

## 📝 Лицензия

MIT License

## 👥 Команда

- Разработка: [Ваше имя]
- Дизайн: [Дизайнер]
- Тестирование: [Тестировщик]

---

**PromoBet** - Лучшая платформа для поиска промо-кодов букмекеров! 🎯
