# 🚀 Быстрый старт серверов

## Три команды для разных сценариев:

### 1. 🏠 Локальная разработка
```bash
php artisan serve:local --vite
```
- ✅ Только localhost (безопасно)
- ✅ Hot reload с Vite
- ❌ Недоступно с других устройств

### 2. 🌐 Демонстрация клиенту
```bash
npm run build
php artisan serve:public
```
- ✅ Только внешние устройства
- ✅ Безопасно (нет локального доступа)
- ❌ Требует `npm run build`

### 3. 🌍 Все устройства
```bash
# Production mode
php artisan serve:all --prod

# Или с Vite
php artisan serve:all --vite
```
- ✅ Доступно везде
- ✅ Гибкие настройки
- ⚠️ Открытый доступ

## Параметры
- `--port=8000` - Порт Laravel
- `--websocket-port=6001` - Порт WebSocket
- `--vite` - Включить Vite dev сервер
- `--prod` - Production mode (только для serve:all)

## Примеры

**Разработка:**
```bash
php artisan serve:local --vite
```

**Демо:**
```bash
npm run build && php artisan serve:public
```

**Тестирование:**
```bash
php artisan serve:all --prod
```

Подробная документация: [SERVE_COMMANDS.md](SERVE_COMMANDS.md) 