# Команды для запуска серверов

У вас есть три команды для разных сценариев запуска серверов:

## 1. 🏠 `serve:local` - Только локальный доступ

Запускает серверы только для доступа с localhost (безопасно для разработки).

```bash
# Базовый запуск
php artisan serve:local

# С Vite dev сервером
php artisan serve:local --vite

# С кастомными портами
php artisan serve:local --port=8080 --websocket-port=6002 --vite
```

**URLs:**
- Laravel: `http://localhost:8000`
- WebSocket: `ws://localhost:6001`
- Chat: `http://localhost:8000/chat-test.html`
- Vite: `http://localhost:5173` (если включен)

**Особенности:**
- ✅ Безопасно - только локальный доступ
- ✅ Быстрая разработка с Vite
- ❌ Недоступно с других устройств

---

## 2. 🌐 `serve:public` - Только публичный доступ

Запускает серверы только для внешних устройств (безопасно для демонстрации).

```bash
# Базовый запуск (требует npm run build)
php artisan serve:public

# С кастомными портами
php artisan serve:public --port=8080 --websocket-port=6002
```

**URLs:**
- Laravel: `http://192.168.0.101:8000`
- WebSocket: `ws://192.168.0.101:6001`
- Chat: `http://192.168.0.101:8000/chat-test.html`

**Особенности:**
- ✅ Доступно с других устройств
- ✅ Безопасно - нет локального доступа
- ❌ Требует собранные assets (`npm run build`)
- ❌ Недоступно с localhost

---

## 3. 🌍 `serve:all` - Все устройства

Запускает серверы для всех устройств (локальный + сетевой доступ).

```bash
# Базовый запуск (production mode)
php artisan serve:all

# С Vite dev сервером
php artisan serve:all --vite

# Только production mode
php artisan serve:all --prod

# С кастомными портами
php artisan serve:all --port=8080 --websocket-port=6002 --vite
```

**URLs:**
- Local: `http://localhost:8000`
- Network: `http://192.168.0.101:8000`
- WebSocket: `ws://192.168.0.101:6001`
- Chat: `http://192.168.0.101:8000/chat-test.html`
- Vite: `http://192.168.0.101:5173` (если включен)

**Особенности:**
- ✅ Доступно везде
- ✅ Гибкие настройки (Vite или production)
- ⚠️ Открытый доступ (настройте firewall)

---

## Параметры команд

Все команды поддерживают следующие параметры:

- `--port=8000` - Порт для Laravel сервера
- `--websocket-port=6001` - Порт для WebSocket сервера
- `--vite` - Включить Vite dev сервер (только для local и all)
- `--prod` - Использовать production mode (только для all)

## Примеры использования

### Разработка
```bash
# Локальная разработка с hot reload
php artisan serve:local --vite
```

### Демонстрация клиенту
```bash
# Собрать assets
npm run build

# Запустить только для внешних устройств
php artisan serve:public
```

### Тестирование на всех устройствах
```bash
# Production mode для всех
php artisan serve:all --prod

# Или с Vite для разработки
php artisan serve:all --vite
```

## Устранение неполадок

### Порт занят
```bash
# Проверить занятые порты
netstat -an | findstr :8000
netstat -an | findstr :6001

# Использовать другие порты
php artisan serve:local --port=8080 --websocket-port=6002
```

### Assets не загружаются
```bash
# Собрать production assets
npm run build

# Или использовать Vite
php artisan serve:all --vite
```

### Firewall блокирует
- Разрешите порты 8000 и 6001 в Windows Firewall
- Проверьте настройки антивируса

### WebSocket не работает
```bash
# Проверить доступность команды
php artisan chat:serve --help

# Проверить логи в окне WebSocket сервера
``` 