<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use App\Models\Rank;

class UpdateUserRanks extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'users:update-ranks';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update ranks for all users based on their current points';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Starting rank update for all users...');
        
        $users = User::all();
        $updatedCount = 0;
        
        $progressBar = $this->output->createProgressBar($users->count());
        $progressBar->start();
        
        foreach ($users as $user) {
            $oldRankId = $user->rank_id;
            $user->updateRank();
            
            if ($oldRankId !== $user->rank_id) {
                $updatedCount++;
                $this->line("\nUser {$user->username}: {$oldRankId} -> {$user->rank_id}");
            }
            
            $progressBar->advance();
        }
        
        $progressBar->finish();
        
        $this->newLine();
        $this->info("Rank update completed!");
        $this->info("Total users processed: {$users->count()}");
        $this->info("Users with updated ranks: {$updatedCount}");
        
        return 0;
    }
} 