<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;
use App\Models\User;

class TrackUserActivity
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $response = $next($request);

        // Обновляем активность ТОЛЬКО для текущего залогиненного пользователя
        if (auth('sanctum')->check()) {
            $user = auth('sanctum')->user();
            $user->updateOnlineStatus(true);
        }

        return $response;
    }
}
