<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Conversation extends Model
{
    use HasFactory;

    protected $fillable = [
        'user1_id',
        'user2_id',
        'last_message_id',
    ];

    protected $table = 'messenger_conversations';

    public function userOne() {
        return $this->belongsTo(User::class, 'user1_id');
    }
    public function userTwo() {
        return $this->belongsTo(User::class, 'user2_id');
    }

    public function messages(): HasMany
    {
        return $this->hasMany(Message::class);
    }

    public function lastMessage(): BelongsTo
    {
        return $this->belongsTo(Message::class, 'last_message_id');
    }

    // Получить собеседника
    public function getInterlocutor(User $user): ?User
    {
        if ($this->user1_id == $user->id) {
            return $this->userTwo;
        }
        if ($this->user2_id == $user->id) {
            return $this->userOne;
        }
        return null;
    }

    // Получить собеседника с проверкой на существование
    public function getInterlocutorSafe(User $user): ?User
    {
        $interlocutor = $this->getInterlocutor($user);
        
        if (!$interlocutor) {
            return null;
        }

        // Добавляем online_status если его нет
        if (!isset($interlocutor->online_status)) {
            $interlocutor->online_status = [
                'is_online' => $interlocutor->isCurrentlyOnline(),
                'status_text' => $interlocutor->getOnlineStatusText(),
                'status_class' => $interlocutor->getOnlineStatusClass(),
                'last_activity' => $interlocutor->last_activity_at ? $interlocutor->last_activity_at->diffForHumans() : null
            ];
        }

        return $interlocutor;
    }
} 