<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class NewsCommentLike extends Model
{
    use HasFactory;

    protected $fillable = [
        'comment_id',
        'user_id',
        'type',
    ];

    /**
     * Комментарий, к которому относится лайк
     */
    public function comment(): BelongsTo
    {
        return $this->belongsTo(NewsComment::class, 'comment_id');
    }

    /**
     * Пользователь, который поставил лайк
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
