<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class ParserJob extends Model
{
    protected $fillable = [
        'name',
        'base_url',
        'pagination_pattern',
        'start_page',
        'end_page',
        'post_selector',
        'title_selector',
        'content_selector',
        'image_selector',
        'link_selector',
        'status',
        'error_message',
        'total_posts',
        'parsed_posts',
        'settings'
    ];

    protected $casts = [
        'settings' => 'array',
        'start_page' => 'integer',
        'end_page' => 'integer',
        'total_posts' => 'integer',
        'parsed_posts' => 'integer'
    ];

    /**
     * Отношение к спарсенным постам
     */
    public function parsedPosts(): HasMany
    {
        return $this->hasMany(ParsedPost::class);
    }

    /**
     * Получить прогресс парсинга в процентах
     */
    public function getProgressAttribute(): int
    {
        if ($this->total_posts === 0) {
            return 0;
        }
        
        return (int) (($this->parsed_posts / $this->total_posts) * 100);
    }

    /**
     * Проверить, завершен ли парсинг
     */
    public function isCompleted(): bool
    {
        return $this->status === 'completed';
    }

    /**
     * Проверить, выполняется ли парсинг
     */
    public function isRunning(): bool
    {
        return $this->status === 'running';
    }

    /**
     * Проверить, есть ли ошибки
     */
    public function hasErrors(): bool
    {
        return $this->status === 'failed';
    }
}
