<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserBlacklist extends Model
{
    use HasFactory;

    protected $table = 'user_blacklist';

    protected $fillable = [
        'user_id',
        'blocked_user_id',
        'reason'
    ];

    /**
     * Пользователь, который заблокировал
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Заблокированный пользователь
     */
    public function blockedUser()
    {
        return $this->belongsTo(User::class, 'blocked_user_id');
    }

    /**
     * Проверить, заблокирован ли пользователь другим пользователем
     */
    public static function isBlocked($userId, $blockedUserId)
    {
        return self::where('user_id', $userId)
                   ->where('blocked_user_id', $blockedUserId)
                   ->exists();
    }

    /**
     * Получить список заблокированных пользователей
     */
    public static function getBlockedUsers($userId)
    {
        return self::where('user_id', $userId)
                   ->with('blockedUser')
                   ->get()
                   ->pluck('blockedUser');
    }

    /**
     * Получить список пользователей, которые заблокировали данного пользователя
     */
    public static function getBlockedByUsers($userId)
    {
        return self::where('blocked_user_id', $userId)
                   ->with('user')
                   ->get()
                   ->pluck('user');
    }
}
