<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('predictions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('sport');
            $table->string('league');
            $table->string('home_team');
            $table->string('away_team');
            $table->string('prediction_type');
            $table->string('prediction_value');
            $table->decimal('odds', 5, 2);
            $table->decimal('stake', 10, 2);
            $table->text('analysis')->nullable();
            $table->enum('status', ['pending', 'won', 'lost', 'void'])->default('pending');
            $table->decimal('profit_loss', 10, 2)->nullable();
            $table->dateTime('match_date');
            $table->boolean('is_public')->default(true);
            $table->integer('likes_count')->default(0);
            $table->integer('dislikes_count')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('predictions');
    }
};
