<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bonuses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('bookmaker_id')->constrained()->onDelete('cascade');
            $table->string('title');
            $table->text('description');
            $table->string('bonus_type');
            $table->decimal('bonus_amount', 10, 2)->nullable();
            $table->string('bonus_currency')->default('RUB');
            $table->decimal('min_deposit', 10, 2)->nullable();
            $table->decimal('max_bonus', 10, 2)->nullable();
            $table->integer('wagering_requirement')->nullable();
            $table->integer('validity_days')->nullable();
            $table->boolean('is_active')->default(true);
            $table->boolean('is_featured')->default(false);
            $table->integer('points_reward')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bonuses');
    }
};
