<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('prediction_likes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('prediction_id')->constrained()->onDelete('cascade');
            $table->timestamps();
            $table->unique(['user_id', 'prediction_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('prediction_likes');
    }
}; 