<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->enum('role', ['user', 'admin', 'moderator'])->default('user')->after('email');
            $table->string('username')->unique()->nullable()->after('role');
            $table->string('avatar')->nullable()->after('username');
            $table->text('bio')->nullable()->after('avatar');
            $table->string('phone')->nullable()->after('bio');
            $table->date('birth_date')->nullable()->after('phone');
            $table->string('country')->nullable()->after('birth_date');
            $table->string('city')->nullable()->after('country');
            $table->string('referral_code')->unique()->nullable()->after('city');
            $table->foreignId('referred_by')->nullable()->constrained('users')->after('referral_code');
            $table->integer('total_points')->default(0)->after('referred_by');
            $table->integer('available_points')->default(0)->after('total_points');
            $table->decimal('total_profit', 10, 2)->default(0.00)->after('available_points');
            $table->integer('predictions_count')->default(0)->after('total_profit');
            $table->integer('correct_predictions')->default(0)->after('predictions_count');
            $table->decimal('success_rate', 5, 2)->default(0.00)->after('correct_predictions');
            $table->boolean('is_verified')->default(false)->after('success_rate');
            $table->timestamp('last_login_at')->nullable()->after('is_verified');
            $table->json('preferences')->nullable()->after('last_login_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['referred_by']);
            $table->dropColumn([
                'role', 'username', 'avatar', 'bio', 'phone', 'birth_date', 
                'country', 'city', 'referral_code', 'referred_by', 'total_points',
                'available_points', 'total_profit', 'predictions_count', 
                'correct_predictions', 'success_rate', 'is_verified', 
                'last_login_at', 'preferences'
            ]);
        });
    }
};
