<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stories', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->text('content')->nullable(); // Текст сториса
            $table->string('media_url')->nullable(); // URL изображения/видео
            $table->enum('type', ['text', 'image', 'video'])->default('text');
            $table->boolean('is_public')->default(true); // Публичный или приватный
            $table->timestamp('expires_at')->nullable(); // Время истечения (24 часа)
            $table->timestamps();
            
            // Индексы для быстрого поиска
            $table->index(['user_id', 'created_at']);
            $table->index(['is_public', 'expires_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stories');
    }
};
