<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Bookmaker;
use App\Models\Category;

class BookmakerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $popularCategory = Category::where('slug', 'popular')->first();
        $licensedCategory = Category::where('slug', 'licensed')->first();
        $highOddsCategory = Category::where('slug', 'high-odds')->first();
        $fastPayoutsCategory = Category::where('slug', 'fast-payouts')->first();
        $cryptoCategory = Category::where('slug', 'crypto')->first();

        $bookmakers = [
            // Популярные букмекеры
            [
                'category_id' => $popularCategory->id,
                'name' => '1xBet',
                'slug' => '1xbet',
                'description' => 'Один из крупнейших букмекеров с широкой линией ставок и высокими коэффициентами',
                'logo' => 'bookmakers/1xbet.png',
                'website_url' => 'https://1xbet.com',
                'affiliate_url' => 'https://1xbet.com/ref/123456',
                'rating' => 4.5,
                'min_deposit' => 100,
                'currency' => 'RUB',
                'features' => ['Лицензия Кюрасао', 'Криптовалюты', 'Live-ставки'],
                'is_featured' => true,
                'sort_order' => 1,
            ],
            [
                'category_id' => $popularCategory->id,
                'name' => 'Bet365',
                'slug' => 'bet365',
                'description' => 'Международный букмекер с высокими коэффициентами и отличной репутацией',
                'logo' => 'bookmakers/bet365.png',
                'website_url' => 'https://bet365.com',
                'affiliate_url' => 'https://bet365.com/ref/123456',
                'rating' => 4.7,
                'min_deposit' => 500,
                'currency' => 'RUB',
                'features' => ['Высокие коэффициенты', 'Live-ставки', 'Видеотрансляции'],
                'is_featured' => true,
                'sort_order' => 2,
            ],
            [
                'category_id' => $popularCategory->id,
                'name' => 'Leon',
                'slug' => 'leon',
                'description' => 'Современный букмекер с удобным интерфейсом и быстрыми выплатами',
                'logo' => 'bookmakers/leon.png',
                'website_url' => 'https://leon.ru',
                'affiliate_url' => 'https://leon.ru/ref/123456',
                'rating' => 4.2,
                'min_deposit' => 100,
                'currency' => 'RUB',
                'features' => ['Современный дизайн', 'Быстрые выплаты', 'Кэшбэк'],
                'is_featured' => false,
                'sort_order' => 3,
            ],
            [
                'category_id' => $popularCategory->id,
                'name' => 'Fonbet',
                'slug' => 'fonbet',
                'description' => 'Российский букмекер с лицензией ЦУПИС и надежной репутацией',
                'logo' => 'bookmakers/fonbet.png',
                'website_url' => 'https://fonbet.ru',
                'affiliate_url' => 'https://fonbet.ru/ref/123456',
                'rating' => 4.3,
                'min_deposit' => 100,
                'currency' => 'RUB',
                'features' => ['Лицензия ЦУПИС', 'Быстрые выплаты', 'Мобильное приложение'],
                'is_featured' => true,
                'sort_order' => 4,
            ],
            [
                'category_id' => $popularCategory->id,
                'name' => 'Marathonbet',
                'slug' => 'marathonbet',
                'description' => 'Букмекер с высокими коэффициентами и широкой линией ставок',
                'logo' => 'bookmakers/marathonbet.png',
                'website_url' => 'https://marathonbet.ru',
                'affiliate_url' => 'https://marathonbet.ru/ref/123456',
                'rating' => 4.1,
                'min_deposit' => 100,
                'currency' => 'RUB',
                'features' => ['Высокие коэффициенты', 'Широкая линия', 'Live-ставки'],
                'is_featured' => false,
                'sort_order' => 5,
            ],

            // Лицензированные букмекеры
            [
                'category_id' => $licensedCategory->id,
                'name' => 'Winline',
                'slug' => 'winline',
                'description' => 'Надежный букмекер с лицензией и отличной поддержкой',
                'logo' => 'bookmakers/winline.png',
                'website_url' => 'https://winline.ru',
                'affiliate_url' => 'https://winline.ru/ref/123456',
                'rating' => 4.0,
                'min_deposit' => 100,
                'currency' => 'RUB',
                'features' => ['Лицензия ЦУПИС', 'Надежность', 'Поддержка 24/7'],
                'is_featured' => false,
                'sort_order' => 6,
            ],
            [
                'category_id' => $licensedCategory->id,
                'name' => 'Liga Stavok',
                'slug' => 'liga-stavok',
                'description' => 'Официальный партнер РПЛ с лицензией ЦУПИС',
                'logo' => 'bookmakers/liga-stavok.png',
                'website_url' => 'https://ligastavok.ru',
                'affiliate_url' => 'https://ligastavok.ru/ref/123456',
                'rating' => 4.4,
                'min_deposit' => 100,
                'currency' => 'RUB',
                'features' => ['Лицензия ЦУПИС', 'Официальный партнер РПЛ', 'Эксклюзивные ставки'],
                'is_featured' => true,
                'sort_order' => 7,
            ],
            [
                'category_id' => $licensedCategory->id,
                'name' => 'Baltbet',
                'slug' => 'baltbet',
                'description' => 'Букмекер с лицензией и широкой сетью офисов',
                'logo' => 'bookmakers/baltbet.png',
                'website_url' => 'https://baltbet.ru',
                'affiliate_url' => 'https://baltbet.ru/ref/123456',
                'rating' => 3.8,
                'min_deposit' => 100,
                'currency' => 'RUB',
                'features' => ['Лицензия ЦУПИС', 'Сеть офисов', 'Наличные ставки'],
                'is_featured' => false,
                'sort_order' => 8,
            ],

            // Букмекеры с высокими коэффициентами
            [
                'category_id' => $highOddsCategory->id,
                'name' => 'Pinnacle',
                'slug' => 'pinnacle',
                'description' => 'Букмекер с самыми высокими коэффициентами в мире',
                'logo' => 'bookmakers/pinnacle.png',
                'website_url' => 'https://pinnacle.com',
                'affiliate_url' => 'https://pinnacle.com/ref/123456',
                'rating' => 4.8,
                'min_deposit' => 1000,
                'currency' => 'USD',
                'features' => ['Максимальные коэффициенты', 'Низкая маржа', 'Профессиональные ставки'],
                'is_featured' => true,
                'sort_order' => 9,
            ],
            [
                'category_id' => $highOddsCategory->id,
                'name' => 'SBOBET',
                'slug' => 'sbobet',
                'description' => 'Азиатский букмекер с высокими коэффициентами',
                'logo' => 'bookmakers/sbobet.png',
                'website_url' => 'https://sbobet.com',
                'affiliate_url' => 'https://sbobet.com/ref/123456',
                'rating' => 4.3,
                'min_deposit' => 500,
                'currency' => 'USD',
                'features' => ['Высокие коэффициенты', 'Азиатские рынки', 'Live-ставки'],
                'is_featured' => false,
                'sort_order' => 10,
            ],
            [
                'category_id' => $highOddsCategory->id,
                'name' => 'Dafabet',
                'slug' => 'dafabet',
                'description' => 'Букмекер с высокими коэффициентами и бонусами',
                'logo' => 'bookmakers/dafabet.png',
                'website_url' => 'https://dafabet.com',
                'affiliate_url' => 'https://dafabet.com/ref/123456',
                'rating' => 4.2,
                'min_deposit' => 300,
                'currency' => 'USD',
                'features' => ['Высокие коэффициенты', 'Щедрые бонусы', 'Кэшбэк'],
                'is_featured' => false,
                'sort_order' => 11,
            ],

            // Букмекеры с быстрыми выплатами
            [
                'category_id' => $fastPayoutsCategory->id,
                'name' => 'Bwin',
                'slug' => 'bwin',
                'description' => 'Международный букмекер с быстрыми выплатами',
                'logo' => 'bookmakers/bwin.png',
                'website_url' => 'https://bwin.com',
                'affiliate_url' => 'https://bwin.com/ref/123456',
                'rating' => 4.1,
                'min_deposit' => 200,
                'currency' => 'EUR',
                'features' => ['Быстрые выплаты', 'Множество методов оплаты', 'Live-ставки'],
                'is_featured' => false,
                'sort_order' => 12,
            ],
            [
                'category_id' => $fastPayoutsCategory->id,
                'name' => 'Unibet',
                'slug' => 'unibet',
                'description' => 'Скандинавский букмекер с быстрыми транзакциями',
                'logo' => 'bookmakers/unibet.png',
                'website_url' => 'https://unibet.com',
                'affiliate_url' => 'https://unibet.com/ref/123456',
                'rating' => 4.0,
                'min_deposit' => 150,
                'currency' => 'EUR',
                'features' => ['Быстрые выплаты', 'Скандинавская надежность', 'Мобильное приложение'],
                'is_featured' => false,
                'sort_order' => 13,
            ],

            // Криптовалютные букмекеры
            [
                'category_id' => $cryptoCategory->id,
                'name' => 'Cloudbet',
                'slug' => 'cloudbet',
                'description' => 'Первый криптовалютный букмекер с поддержкой Bitcoin',
                'logo' => 'bookmakers/cloudbet.png',
                'website_url' => 'https://cloudbet.com',
                'affiliate_url' => 'https://cloudbet.com/ref/123456',
                'rating' => 4.2,
                'min_deposit' => 50,
                'currency' => 'BTC',
                'features' => ['Криптовалюты', 'Анонимность', 'Быстрые транзакции'],
                'is_featured' => true,
                'sort_order' => 14,
            ],
            [
                'category_id' => $cryptoCategory->id,
                'name' => 'Nitrogen Sports',
                'slug' => 'nitrogen-sports',
                'description' => 'Криптовалютный букмекер с поддержкой Bitcoin',
                'logo' => 'bookmakers/nitrogen-sports.png',
                'website_url' => 'https://nitrogensports.eu',
                'affiliate_url' => 'https://nitrogensports.eu/ref/123456',
                'rating' => 3.9,
                'min_deposit' => 25,
                'currency' => 'BTC',
                'features' => ['Bitcoin', 'Анонимность', 'Низкие комиссии'],
                'is_featured' => false,
                'sort_order' => 15,
            ],
            [
                'category_id' => $cryptoCategory->id,
                'name' => 'FortuneJack',
                'slug' => 'fortunejack',
                'description' => 'Криптовалютный букмекер с множеством криптовалют',
                'logo' => 'bookmakers/fortunejack.png',
                'website_url' => 'https://fortunejack.com',
                'affiliate_url' => 'https://fortunejack.com/ref/123456',
                'rating' => 4.0,
                'min_deposit' => 30,
                'currency' => 'BTC',
                'features' => ['Множество криптовалют', 'Казино', 'Быстрые выплаты'],
                'is_featured' => false,
                'sort_order' => 16,
            ],

            // Дополнительные популярные букмекеры
            [
                'category_id' => $popularCategory->id,
                'name' => 'William Hill',
                'slug' => 'william-hill',
                'description' => 'Старейший британский букмекер с отличной репутацией',
                'logo' => 'bookmakers/william-hill.png',
                'website_url' => 'https://williamhill.com',
                'affiliate_url' => 'https://williamhill.com/ref/123456',
                'rating' => 4.4,
                'min_deposit' => 200,
                'currency' => 'GBP',
                'features' => ['Британская надежность', 'Высокие коэффициенты', 'Live-ставки'],
                'is_featured' => true,
                'sort_order' => 17,
            ],
            [
                'category_id' => $popularCategory->id,
                'name' => 'Ladbrokes',
                'slug' => 'ladbrokes',
                'description' => 'Крупнейший британский букмекер с сетью магазинов',
                'logo' => 'bookmakers/ladbrokes.png',
                'website_url' => 'https://ladbrokes.com',
                'affiliate_url' => 'https://ladbrokes.com/ref/123456',
                'rating' => 4.3,
                'min_deposit' => 150,
                'currency' => 'GBP',
                'features' => ['Сеть магазинов', 'Британская лицензия', 'Широкая линия'],
                'is_featured' => false,
                'sort_order' => 18,
            ],
            [
                'category_id' => $popularCategory->id,
                'name' => 'Betfair',
                'slug' => 'betfair',
                'description' => 'Пионер биржи ставок с уникальными возможностями',
                'logo' => 'bookmakers/betfair.png',
                'website_url' => 'https://betfair.com',
                'affiliate_url' => 'https://betfair.com/ref/123456',
                'rating' => 4.5,
                'min_deposit' => 300,
                'currency' => 'GBP',
                'features' => ['Биржа ставок', 'Уникальные рынки', 'Высокие коэффициенты'],
                'is_featured' => true,
                'sort_order' => 19,
            ],
            [
                'category_id' => $popularCategory->id,
                'name' => 'Paddy Power',
                'slug' => 'paddy-power',
                'description' => 'Ирландский букмекер с отличным юмором и бонусами',
                'logo' => 'bookmakers/paddy-power.png',
                'website_url' => 'https://paddypower.com',
                'affiliate_url' => 'https://paddypower.com/ref/123456',
                'rating' => 4.2,
                'min_deposit' => 100,
                'currency' => 'EUR',
                'features' => ['Щедрые бонусы', 'Юмористические ставки', 'Live-ставки'],
                'is_featured' => false,
                'sort_order' => 20,
            ],

            // Дополнительные лицензированные
            [
                'category_id' => $licensedCategory->id,
                'name' => 'Tennis.ru',
                'slug' => 'tennis-ru',
                'description' => 'Специализированный букмекер на теннис с лицензией',
                'logo' => 'bookmakers/tennis-ru.png',
                'website_url' => 'https://tennis.ru',
                'affiliate_url' => 'https://tennis.ru/ref/123456',
                'rating' => 3.9,
                'min_deposit' => 100,
                'currency' => 'RUB',
                'features' => ['Лицензия ЦУПИС', 'Специализация на теннис', 'Экспертные прогнозы'],
                'is_featured' => false,
                'sort_order' => 21,
            ],
            [
                'category_id' => $licensedCategory->id,
                'name' => 'Olimp',
                'slug' => 'olimp',
                'description' => 'Букмекер с лицензией и широкой сетью офисов',
                'logo' => 'bookmakers/olimp.png',
                'website_url' => 'https://olimp.com',
                'affiliate_url' => 'https://olimp.com/ref/123456',
                'rating' => 3.8,
                'min_deposit' => 100,
                'currency' => 'RUB',
                'features' => ['Лицензия ЦУПИС', 'Сеть офисов', 'Наличные ставки'],
                'is_featured' => false,
                'sort_order' => 22,
            ],

            // Дополнительные с высокими коэффициентами
            [
                'category_id' => $highOddsCategory->id,
                'name' => 'Betway',
                'slug' => 'betway',
                'description' => 'Букмекер с высокими коэффициентами и спонсорством',
                'logo' => 'bookmakers/betway.png',
                'website_url' => 'https://betway.com',
                'affiliate_url' => 'https://betway.com/ref/123456',
                'rating' => 4.1,
                'min_deposit' => 200,
                'currency' => 'EUR',
                'features' => ['Высокие коэффициенты', 'Спонсорство команд', 'Live-ставки'],
                'is_featured' => false,
                'sort_order' => 23,
            ],
            [
                'category_id' => $highOddsCategory->id,
                'name' => '888sport',
                'slug' => '888sport',
                'description' => 'Букмекер с высокими коэффициентами и бонусами',
                'logo' => 'bookmakers/888sport.png',
                'website_url' => 'https://888sport.com',
                'affiliate_url' => 'https://888sport.com/ref/123456',
                'rating' => 4.0,
                'min_deposit' => 150,
                'currency' => 'EUR',
                'features' => ['Высокие коэффициенты', 'Щедрые бонусы', 'Мобильное приложение'],
                'is_featured' => false,
                'sort_order' => 24,
            ],

            // Дополнительные с быстрыми выплатами
            [
                'category_id' => $fastPayoutsCategory->id,
                'name' => 'LeoVegas',
                'slug' => 'leovegas',
                'description' => 'Мобильный букмекер с быстрыми выплатами',
                'logo' => 'bookmakers/leovegas.png',
                'website_url' => 'https://leovegas.com',
                'affiliate_url' => 'https://leovegas.com/ref/123456',
                'rating' => 4.2,
                'min_deposit' => 100,
                'currency' => 'EUR',
                'features' => ['Быстрые выплаты', 'Мобильная оптимизация', 'Live-ставки'],
                'is_featured' => false,
                'sort_order' => 25,
            ],
            [
                'category_id' => $fastPayoutsCategory->id,
                'name' => 'Mr Green',
                'slug' => 'mr-green',
                'description' => 'Экологичный букмекер с быстрыми транзакциями',
                'logo' => 'bookmakers/mr-green.png',
                'website_url' => 'https://mrgreen.com',
                'affiliate_url' => 'https://mrgreen.com/ref/123456',
                'rating' => 3.9,
                'min_deposit' => 120,
                'currency' => 'EUR',
                'features' => ['Быстрые выплаты', 'Экологичность', 'Уникальный дизайн'],
                'is_featured' => false,
                'sort_order' => 26,
            ],

            // Дополнительные криптовалютные
            [
                'category_id' => $cryptoCategory->id,
                'name' => '1xBit',
                'slug' => '1xbit',
                'description' => 'Криптовалютный букмекер с множеством валют',
                'logo' => 'bookmakers/1xbit.png',
                'website_url' => 'https://1xbit.com',
                'affiliate_url' => 'https://1xbit.com/ref/123456',
                'rating' => 4.1,
                'min_deposit' => 40,
                'currency' => 'BTC',
                'features' => ['Множество криптовалют', 'Анонимность', 'Быстрые транзакции'],
                'is_featured' => false,
                'sort_order' => 27,
            ],
            [
                'category_id' => $cryptoCategory->id,
                'name' => 'Betcoin.ag',
                'slug' => 'betcoin-ag',
                'description' => 'Криптовалютный букмекер с казино',
                'logo' => 'bookmakers/betcoin-ag.png',
                'website_url' => 'https://betcoin.ag',
                'affiliate_url' => 'https://betcoin.ag/ref/123456',
                'rating' => 3.8,
                'min_deposit' => 35,
                'currency' => 'BTC',
                'features' => ['Криптовалюты', 'Казино', 'Анонимность'],
                'is_featured' => false,
                'sort_order' => 28,
            ],

            // Дополнительные популярные
            [
                'category_id' => $popularCategory->id,
                'name' => 'Coral',
                'slug' => 'coral',
                'description' => 'Британский букмекер с сетью магазинов',
                'logo' => 'bookmakers/coral.png',
                'website_url' => 'https://coral.co.uk',
                'affiliate_url' => 'https://coral.co.uk/ref/123456',
                'rating' => 4.0,
                'min_deposit' => 180,
                'currency' => 'GBP',
                'features' => ['Сеть магазинов', 'Британская лицензия', 'Live-ставки'],
                'is_featured' => false,
                'sort_order' => 29,
            ],
            [
                'category_id' => $popularCategory->id,
                'name' => 'Betfred',
                'slug' => 'betfred',
                'description' => 'Британский букмекер с отличными бонусами',
                'logo' => 'bookmakers/betfred.png',
                'website_url' => 'https://betfred.com',
                'affiliate_url' => 'https://betfred.com/ref/123456',
                'rating' => 4.1,
                'min_deposit' => 160,
                'currency' => 'GBP',
                'features' => ['Щедрые бонусы', 'Британская лицензия', 'Live-ставки'],
                'is_featured' => false,
                'sort_order' => 30,
            ],
        ];

        foreach ($bookmakers as $bookmaker) {
            Bookmaker::create($bookmaker);
        }
    }
}
