<?php

namespace Database\Seeders;

use App\Models\NewsCategory;
use Illuminate\Database\Seeder;

class NewsCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        NewsCategory::create([
            'name' => 'Стратегии ставок на футбол',
            'slug' => 'football-betting-strategies',
            'description' => 'Экспертные стратегии и тактики для успешных ставок на футбольные матчи',
            'color' => '#10B981', // зеленый цвет для футбола
            'icon' => '⚽',
            'is_active' => true,
            'sort_order' => 1,
        ]);

        // Дополнительные категории для будущего использования
        NewsCategory::create([
            'name' => 'Анализ матчей',
            'slug' => 'match-analysis',
            'description' => 'Детальный анализ предстоящих матчей и статистика команд',
            'color' => '#3B82F6', // синий
            'icon' => '📊',
            'is_active' => true,
            'sort_order' => 2,
        ]);

        NewsCategory::create([
            'name' => 'Новости букмекеров',
            'slug' => 'bookmaker-news',
            'description' => 'Актуальные новости от букмекерских контор и изменения в линиях',
            'color' => '#F59E0B', // оранжевый
            'icon' => '📰',
            'is_active' => true,
            'sort_order' => 3,
        ]);

        NewsCategory::create([
            'name' => 'Промо-акции',
            'slug' => 'promotions',
            'description' => 'Лучшие бонусы и промо-акции от букмекерских контор',
            'color' => '#EF4444', // красный
            'icon' => '🎁',
            'is_active' => true,
            'sort_order' => 4,
        ]);

        NewsCategory::create([
            'name' => 'Советы экспертов',
            'slug' => 'expert-tips',
            'description' => 'Советы и рекомендации от профессиональных прогнозистов',
            'color' => '#8B5CF6', // фиолетовый
            'icon' => '🎯',
            'is_active' => true,
            'sort_order' => 5,
        ]);
    }
}
