<?php

namespace Database\Seeders;

use App\Models\News;
use App\Models\NewsCategory;
use App\Models\User;
use Illuminate\Database\Seeder;

class NewsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Получаем категорию и первого пользователя
        $category = NewsCategory::where('slug', 'football-betting-strategies')->first();
        $author = User::first() ?? User::factory()->create();

        if (!$category) {
            $this->command->error('Категория "Стратегии ставок на футбол" не найдена. Запустите NewsCategorySeeder сначала.');
            return;
        }

        News::create([
            'category_id' => $category->id,
            'author_id' => $author->id,
            'title' => 'Стратегия ставок на интервалы голов: как искать валуй, кто принимает ставки',
            'slug' => 'strategiya-stavok-na-intervaly-golov-kak-iskat-valyuy',
            'excerpt' => 'Разбираем прибыльную стратегию ставок на временные интервалы голов в футбольных матчах. Узнайте, какие букмекеры предлагают лучшие коэффициенты и где брать статистику для анализа.',
            'content' => '<h2>Суть рынка интервалов голов</h2>
<p>Букмекерские конторы предлагают уникальную возможность – спрогнозировать, в каком временном отрезке будет забит гол. Матч разбивается на интервалы (обычно по 10-15 минут, реже по 30), и игроки могут делать ставки на различные сценарии развития событий.</p>

<h3>Основные варианты ставок:</h3>
<ul>
<li><strong>Гол в интервале:</strong> любой команды или конкретной</li>
<li><strong>Тотал на интервал:</strong> общий и индивидуальный</li>
<li><strong>Промежуточный исход:</strong> чистый и двойной результат</li>
<li><strong>Фора на интервал:</strong> преимущество одной из команд</li>
<li><strong>Первый гол:</strong> в каком отрезке произойдет</li>
</ul>

<p>Наиболее удобными для анализа считаются 15-минутные интервалы – они дают оптимальный баланс между точностью прогноза и доступностью статистики.</p>

<h2>Топ букмекеров с лучшими коэффициентами</h2>
<p>Следующие конторы предлагают наиболее выгодные условия для ставок на интервалы (указана маржа):</p>

<div class="bookmaker-list">
<div class="bookmaker-item">
<h4>🏆 Марафон</h4>
<p>Маржа: <strong>5,3%</strong> - лучшие коэффициенты в отрасли</p>
</div>

<div class="bookmaker-item">
<h4>🥈 БЕТСИТИ</h4>
<p>Маржа: <strong>7%</strong> - стабильно низкая маржа</p>
</div>

<div class="bookmaker-item">
<h4>🥉 Зенит</h4>
<p>Маржа: <strong>8%</strong> - хороший выбор для опытных игроков</p>
</div>

<div class="bookmaker-item">
<h4>📊 Тенниси</h4>
<p>Маржа: <strong>8%</strong> - качественная линия</p>
</div>

<div class="bookmaker-item">
<h4>🎯 PARI</h4>
<p>Маржа: <strong>8,5%</strong> - надежная контора</p>
</div>

<div class="bookmaker-item">
<h4>⚡ Мелбет</h4>
<p>Маржа: <strong>8,5%</strong> - быстрые выплаты</p>
</div>

<div class="bookmaker-item">
<h4>🚀 BetBoom</h4>
<p>Маржа: <strong>8,5%</strong> - современная платформа</p>
</div>
</div>

<p><strong>Внимание:</strong> Winline предлагает ограниченный выбор – только ставки на первый гол в 10-15 минутных интервалах с высокой маржей около 20%.</p>

<h2>Где брать статистику для анализа</h2>
<p>Для успешной игры на интервалах достаточно трех бесплатных сервисов:</p>

<h3>📈 24score.pro</h3>
<p><strong>Раздел:</strong> «Забитые голы»<br>
<strong>Преимущества:</strong></p>
<ul>
<li>Все 10- и 15-минутные интервалы команд лиги на одной странице</li>
<li>Статистика в абсолютных и процентных значениях</li>
<li>Покрытие от топ-лиг до второй лиги Турции</li>
<li>Удобная визуализация данных</li>
</ul>

<h3>📊 whoscored.com</h3>
<p><strong>Раздел:</strong> «Team Statistics» → «Detailed»<br>
<strong>Преимущества:</strong></p>
<ul>
<li>Детальная раскладка по 15-минутным отрезкам</li>
<li>Не только голы, но и другие статистические показатели</li>
<li>Профессиональный анализ данных</li>
<li>Историческая статистика</li>
</ul>

<h3>⚽ football.nowgoal6.com</h3>
<p><strong>Раздел:</strong> «Goal time»<br>
<strong>Преимущества:</strong></p>
<ul>
<li>Разбивка по 5-минутным отрезкам</li>
<li>Максимальная детализация</li>
<li>Азиатские лиги</li>
<li>Быстрое обновление данных</li>
</ul>

<h2>Практические примеры поиска валуйных ставок</h2>

<h3>🎯 Пример 1: Вулверхэмптон – Астон Вилла</h3>
<p><strong>Статистика:</strong></p>
<ul>
<li>Астон Вилла: 32% голов в первые 15 минут</li>
<li>Вулверхэмптон: 29% голов в первые 15 минут</li>
<li>Суммарно: 0,62 гола на этот отрезок</li>
</ul>
<p><strong>Стратегия:</strong> Коэффициент на гол в первые 15 минут обычно 3,0-3,2. При такой статистике это валуйная ставка.</p>

<h3>🎯 Пример 2: Нант – Аяччо</h3>
<p><strong>Статистика:</strong></p>
<ul>
<li>Нант: всего 2 гола в первые 30 минут за сезон</li>
<li>Аяччо: всего 2 гола в первые 30 минут за сезон</li>
<li>Команды активизируются после 60-й минуты</li>
</ul>
<p><strong>Стратегия:</strong> Ставим «Гол до 30-й минуты: нет» - высокий шанс на проход.</p>

<h3>🎯 Пример 3: Поздние голы в топ-матчах</h3>
<p><strong>Лидеры по голам после 75-й минуты:</strong></p>
<ul>
<li>ПСЖ: 0,61 гола за игру</li>
<li>Наполи: 0,57 гола за игру</li>
<li>Реал Мадрид: 0,57 гола за игру</li>
<li>Боруссия Дортмунд: 0,55 гола за игру</li>
<li>Манчестер Юнайтед: 0,48 гола за игру</li>
</ul>
<p><strong>Стратегия:</strong> В матчах этих команд в еврокубках высокий шанс на голы после 75-й минуты.</p>

<h2>Важные нюансы стратегии</h2>
<ul>
<li><strong>Анализируйте последние 10-15 матчей</strong> команды для актуальной статистики</li>
<li><strong>Учитывайте мотивацию</strong> - в важных матчах команды могут менять тактику</li>
<li><strong>Следите за травмами</strong> ключевых игроков</li>
<li><strong>Проверяйте погодные условия</strong> - они могут влиять на темп игры</li>
<li><strong>Используйте несколько источников</strong> статистики для подтверждения</li>
</ul>

<p>Эта стратегия требует тщательного анализа, но при правильном подходе может приносить стабильную прибыль. Главное – не гнаться за высокими коэффициентами, а искать реальные валуйные ставки на основе статистики.</p>',
            'featured_image' => null,
            'images' => null,
            'tags' => ['стратегии', 'футбол', 'интервалы', 'голы', 'валуй', 'букмекеры', 'статистика'],
            'status' => 'published',
            'is_featured' => true,
            'is_pinned' => false,
            'published_at' => now(),
            'views_count' => 0,
            'likes_count' => 0,
            'comments_count' => 0,
            'meta_title' => 'Стратегия ставок на интервалы голов: поиск валуйных ставок',
            'meta_description' => 'Узнайте, как правильно анализировать временные интервалы в футбольных матчах и находить валуйные ставки. Топ букмекеров и источники статистики.',
            'meta_keywords' => ['ставки на интервалы', 'футбольные стратегии', 'валуйные ставки', 'статистика голов'],
        ]);

        $this->command->info('Новость "Стратегия ставок на интервалы голов" успешно создана!');
    }
}
