<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Prediction;
use App\Models\User;

class PredictionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Проверяем, что тестовые пользователи существуют
        $users = User::take(5)->get();
        if ($users->isEmpty()) {
            $this->command->error('No users found. Please run TestUserSeeder first.');
            return;
        }

        $predictions = [
            // Существующие прогнозы
            [
                'user_id' => $users[0]->id,
                'sport' => 'football',
                'league' => 'Английская Премьер-лига',
                'home_team' => 'Манчестер Юнайтед',
                'away_team' => 'Ливерпуль',
                'prediction_type' => 'match_winner',
                'prediction_value' => 'home_win',
                'odds' => 2.45,
                'stake' => 100,
                'analysis' => 'Манчестер Юнайтед показывает отличную форму в домашних матчах. В последних 5 домашних играх команда не проигрывала. Ливерпуль испытывает проблемы с травмами ключевых игроков.',
                'status' => 'pending',
                'match_date' => now()->addDays(3),
                'is_public' => true,
                'likes_count' => 15,
                'dislikes_count' => 3,
            ],
            [
                'user_id' => $users[0]->id,
                'sport' => 'basketball',
                'league' => 'NBA',
                'home_team' => 'Лос-Анджелес Лейкерс',
                'away_team' => 'Голден Стэйт Уорриорз',
                'prediction_type' => 'total_points',
                'prediction_value' => 'over_220.5',
                'odds' => 1.85,
                'stake' => 150,
                'analysis' => 'Обе команды показывают высокую результативность в последних матчах. Лейкерс в среднем набирают 115 очков дома, Уорриорз - 108 в гостях. Ожидаю высокоскоростную игру.',
                'status' => 'pending',
                'match_date' => now()->addDays(2),
                'is_public' => true,
                'likes_count' => 23,
                'dislikes_count' => 7,
            ],
            [
                'user_id' => $users[0]->id,
                'sport' => 'tennis',
                'league' => 'Wimbledon',
                'home_team' => 'Новак Джокович',
                'away_team' => 'Карлос Алькарас',
                'prediction_type' => 'match_winner',
                'prediction_value' => 'away_win',
                'odds' => 1.95,
                'stake' => 200,
                'analysis' => 'Алькарас показывает отличную форму на траве. Джокович не в лучшей форме после травмы. Молодой испанец имеет преимущество в скорости и подвижности.',
                'status' => 'pending',
                'match_date' => now()->addDays(5),
                'is_public' => true,
                'likes_count' => 31,
                'dislikes_count' => 12,
            ],
            [
                'user_id' => $users[0]->id,
                'sport' => 'hockey',
                'league' => 'НХЛ',
                'home_team' => 'Торонто Мейпл Лифс',
                'away_team' => 'Бостон Брюинз',
                'prediction_type' => 'total_goals',
                'prediction_value' => 'under_5.5',
                'odds' => 2.10,
                'stake' => 120,
                'analysis' => 'Обе команды имеют сильные оборонительные линии. В последних встречах между этими командами редко забивается больше 5 голов. Ожидаю тактическую игру.',
                'status' => 'pending',
                'match_date' => now()->addDays(1),
                'is_public' => true,
                'likes_count' => 8,
                'dislikes_count' => 4,
            ],
            [
                'user_id' => $users[0]->id,
                'sport' => 'volleyball',
                'league' => 'Чемпионат России',
                'home_team' => 'Зенит Казань',
                'away_team' => 'Локомотив Новосибирск',
                'prediction_type' => 'match_winner',
                'prediction_value' => 'home_win',
                'odds' => 1.65,
                'stake' => 180,
                'analysis' => 'Зенит показывает отличную игру дома. Команда не проигрывала в последних 8 домашних матчах. Локомотив испытывает проблемы с выездными играми.',
                'status' => 'pending',
                'match_date' => now()->addDays(4),
                'is_public' => true,
                'likes_count' => 19,
                'dislikes_count' => 6,
            ],
            [
                'user_id' => $users[0]->id,
                'sport' => 'football',
                'league' => 'Испанская Ла Лига',
                'home_team' => 'Реал Мадрид',
                'away_team' => 'Барселона',
                'prediction_type' => 'both_teams_score',
                'prediction_value' => 'yes',
                'odds' => 1.75,
                'stake' => 160,
                'analysis' => 'Классико всегда высокорезультативен. Обе команды имеют мощные атакующие линии. В последних 10 встречах обе команды забивали в 8 случаях.',
                'status' => 'pending',
                'match_date' => now()->addDays(7),
                'is_public' => true,
                'likes_count' => 42,
                'dislikes_count' => 9,
            ],

            // Новые прогнозы - 10 штук
            [
                'user_id' => $users[1]->id ?? $users[0]->id,
                'sport' => 'football',
                'league' => 'Итальянская Серия А',
                'home_team' => 'Ювентус',
                'away_team' => 'Милан',
                'prediction_type' => 'match_winner',
                'prediction_value' => 'draw',
                'odds' => 3.20,
                'stake' => 80,
                'analysis' => 'Обе команды в равной форме. Ювентус силен дома, но Милан показывает стабильную игру в гостях. В последних 5 встречах было 3 ничьих.',
                'status' => 'pending',
                'match_date' => now()->addDays(6),
                'is_public' => true,
                'likes_count' => 12,
                'dislikes_count' => 5,
            ],
            [
                'user_id' => $users[2]->id ?? $users[0]->id,
                'sport' => 'basketball',
                'league' => 'Евролига',
                'home_team' => 'ЦСКА Москва',
                'away_team' => 'Реал Мадрид',
                'prediction_type' => 'handicap',
                'prediction_value' => 'home_win_-5.5',
                'odds' => 1.90,
                'stake' => 200,
                'analysis' => 'ЦСКА в отличной форме дома. Команда выиграла последние 7 домашних матчей с разницей в среднем 12 очков. Реал испытывает проблемы с выездными играми.',
                'status' => 'pending',
                'match_date' => now()->addDays(8),
                'is_public' => true,
                'likes_count' => 28,
                'dislikes_count' => 11,
            ],
            [
                'user_id' => $users[3]->id ?? $users[0]->id,
                'sport' => 'tennis',
                'league' => 'US Open',
                'home_team' => 'Даниил Медведев',
                'away_team' => 'Джанни Синнер',
                'prediction_type' => 'match_winner',
                'prediction_value' => 'home_win',
                'odds' => 2.15,
                'stake' => 150,
                'analysis' => 'Медведев показывает отличную форму на харде. В последних 10 матчах на этой поверхности он проиграл только один раз. Синнер не в лучшей форме.',
                'status' => 'pending',
                'match_date' => now()->addDays(10),
                'is_public' => true,
                'likes_count' => 35,
                'dislikes_count' => 8,
            ],
            [
                'user_id' => $users[4]->id ?? $users[0]->id,
                'sport' => 'hockey',
                'league' => 'КХЛ',
                'home_team' => 'Ак Барс',
                'away_team' => 'Салават Юлаев',
                'prediction_type' => 'total_goals',
                'prediction_value' => 'over_4.5',
                'odds' => 1.75,
                'stake' => 120,
                'analysis' => 'Обе команды показывают высокую результативность. Ак Барс в среднем забивает 3.2 гола дома, Салават - 2.8 в гостях. Ожидаю результативную игру.',
                'status' => 'pending',
                'match_date' => now()->addDays(9),
                'is_public' => true,
                'likes_count' => 16,
                'dislikes_count' => 3,
            ],
            [
                'user_id' => $users[1]->id ?? $users[0]->id,
                'sport' => 'football',
                'league' => 'Немецкая Бундеслига',
                'home_team' => 'Бавария',
                'away_team' => 'Боруссия Дортмунд',
                'prediction_type' => 'correct_score',
                'prediction_value' => '3-1',
                'odds' => 8.50,
                'stake' => 50,
                'analysis' => 'Бавария в отличной форме дома. Команда забивает в среднем 3.2 гола за матч. Дортмунд слаб в защите в гостевых матчах.',
                'status' => 'pending',
                'match_date' => now()->addDays(12),
                'is_public' => true,
                'likes_count' => 8,
                'dislikes_count' => 15,
            ],
            [
                'user_id' => $users[2]->id ?? $users[0]->id,
                'sport' => 'volleyball',
                'league' => 'Лига Чемпионов',
                'home_team' => 'Трентино',
                'away_team' => 'Перуджа',
                'prediction_type' => 'match_winner',
                'prediction_value' => 'away_win',
                'odds' => 2.30,
                'stake' => 100,
                'analysis' => 'Перуджа показывает отличную игру в последних матчах. Команда выиграла 8 из последних 10 игр. Трентино испытывает проблемы с травмами.',
                'status' => 'pending',
                'match_date' => now()->addDays(11),
                'is_public' => true,
                'likes_count' => 22,
                'dislikes_count' => 9,
            ],
            [
                'user_id' => $users[3]->id ?? $users[0]->id,
                'sport' => 'basketball',
                'league' => 'NBA',
                'home_team' => 'Бостон Селтикс',
                'away_team' => 'Филадельфия 76ers',
                'prediction_type' => 'total_points',
                'prediction_value' => 'under_210.5',
                'odds' => 1.95,
                'stake' => 180,
                'analysis' => 'Обе команды имеют сильные оборонительные линии. В последних встречах редко набирается больше 210 очков. Ожидаю тактическую игру.',
                'status' => 'pending',
                'match_date' => now()->addDays(13),
                'is_public' => true,
                'likes_count' => 19,
                'dislikes_count' => 7,
            ],
            [
                'user_id' => $users[4]->id ?? $users[0]->id,
                'sport' => 'football',
                'league' => 'Французская Лига 1',
                'home_team' => 'ПСЖ',
                'away_team' => 'Марсель',
                'prediction_type' => 'both_teams_score',
                'prediction_value' => 'no',
                'odds' => 2.40,
                'stake' => 90,
                'analysis' => 'ПСЖ показывает отличную оборону дома. Команда не пропускала в последних 5 домашних матчах. Марсель слаб в атаке в гостевых играх.',
                'status' => 'pending',
                'match_date' => now()->addDays(14),
                'is_public' => true,
                'likes_count' => 14,
                'dislikes_count' => 6,
            ],
            [
                'user_id' => $users[1]->id ?? $users[0]->id,
                'sport' => 'tennis',
                'league' => 'Australian Open',
                'home_team' => 'Ига Свёнтек',
                'away_team' => 'Арина Сабаленка',
                'prediction_type' => 'match_winner',
                'prediction_value' => 'away_win',
                'odds' => 2.10,
                'stake' => 130,
                'analysis' => 'Сабаленка показывает отличную форму на харде. В последних матчах она обыгрывала Свёнтек. Белоруска имеет преимущество в подаче.',
                'status' => 'pending',
                'match_date' => now()->addDays(15),
                'is_public' => true,
                'likes_count' => 26,
                'dislikes_count' => 12,
            ],
            [
                'user_id' => $users[2]->id ?? $users[0]->id,
                'sport' => 'hockey',
                'league' => 'НХЛ',
                'home_team' => 'Эдмонтон Ойлерз',
                'away_team' => 'Калгари Флэймз',
                'prediction_type' => 'match_winner',
                'prediction_value' => 'home_win',
                'odds' => 1.85,
                'stake' => 140,
                'analysis' => 'Ойлерз в отличной форме дома. Команда выиграла последние 6 домашних матчей. Флэймз испытывают проблемы с выездными играми.',
                'status' => 'pending',
                'match_date' => now()->addDays(16),
                'is_public' => true,
                'likes_count' => 31,
                'dislikes_count' => 8,
            ],
        ];

        foreach ($predictions as $predictionData) {
            Prediction::create($predictionData);
        }

        $this->command->info('Predictions seeded successfully!');
    }
} 