<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Slot;
use Illuminate\Support\Str;

class SlotSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $slots = [
            [
                'name' => 'Book of Dead',
                'slug' => 'book-of-dead',
                'description' => 'Классический слот с египетской тематикой и высоким потенциалом выигрыша. Исследуйте древние гробницы в поисках сокровищ.',
                'provider' => 'Play\'n GO',
                'theme' => 'Египет',
                'rtp' => 96.21,
                'volatility' => 3.5,
                'min_bet' => 10,
                'max_bet' => 100000,
                'max_win' => 500000,
                'paylines' => 10,
                'reels' => 5,
                'release_date' => '2016-01-01',
                'rating' => 4.8,
                'plays_count' => 1500000,
                'features' => ['Free Spins', 'Expanding Symbols', 'Gamble Feature'],
                'bonus_features' => ['Book Symbol', 'Scatter Wins', 'Risk Game'],
                'demo_url' => 'https://demo.playngo.com/book-of-dead',
                'real_url' => 'https://casino.example.com/book-of-dead',
                'iframe_url' => 'https://games.playngo.com/game/book-of-dead',
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => 'Book of Dead - Египетский слот с высоким RTP',
                'meta_description' => 'Играйте в Book of Dead от Play\'n GO. Египетская тематика, высокий RTP 96.21%, бесплатные вращения.',
            ],
            [
                'name' => 'Starburst',
                'slug' => 'starburst',
                'description' => 'Космический слот с яркими драгоценными камнями и захватывающими бонусами. Один из самых популярных слотов в мире.',
                'provider' => 'NetEnt',
                'theme' => 'Космос',
                'rtp' => 96.09,
                'volatility' => 2.0,
                'min_bet' => 10,
                'max_bet' => 100000,
                'max_win' => 500000,
                'paylines' => 10,
                'reels' => 5,
                'release_date' => '2012-01-01',
                'rating' => 4.7,
                'plays_count' => 2000000,
                'features' => ['Wilds', 'Re-spins', 'Expanding Wilds'],
                'bonus_features' => ['Starburst Wilds', 'Re-spin Feature'],
                'demo_url' => 'https://demo.netent.com/starburst',
                'real_url' => 'https://casino.example.com/starburst',
                'iframe_url' => 'https://games.netent.com/game/starburst',
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => 'Starburst - Космический слот с драгоценными камнями',
                'meta_description' => 'Starburst от NetEnt - популярный космический слот с яркими драгоценными камнями и захватывающими бонусами.',
            ],
            [
                'name' => 'Gonzo\'s Quest',
                'slug' => 'gonzos-quest',
                'description' => 'Приключения конкистадора в поисках золота Эльдорадо. Инновационный слот с падающими символами и множителями.',
                'provider' => 'NetEnt',
                'theme' => 'Приключения',
                'rtp' => 95.97,
                'volatility' => 3.0,
                'min_bet' => 20,
                'max_bet' => 500000,
                'max_win' => 2500000,
                'paylines' => 20,
                'reels' => 5,
                'release_date' => '2011-01-01',
                'rating' => 4.9,
                'plays_count' => 1800000,
                'features' => ['Avalanche Reels', 'Free Falls', 'Multipliers'],
                'bonus_features' => ['Free Fall Feature', 'Avalanche Multipliers'],
                'demo_url' => 'https://demo.netent.com/gonzos-quest',
                'real_url' => 'https://casino.example.com/gonzos-quest',
                'iframe_url' => 'https://games.netent.com/game/gonzos-quest',
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => 'Gonzo\'s Quest - Приключения конкистадора',
                'meta_description' => 'Gonzo\'s Quest от NetEnt - приключенческий слот с падающими символами и множителями.',
            ],
            [
                'name' => 'Mega Fortune',
                'slug' => 'mega-fortune',
                'description' => 'Роскошный слот с прогрессивным джекпотом и стилем жизни миллионера. Возможность выиграть миллионы!',
                'provider' => 'NetEnt',
                'theme' => 'Роскошь',
                'rtp' => 96.6,
                'volatility' => 4.0,
                'min_bet' => 25,
                'max_bet' => 150000,
                'max_win' => 10000000,
                'paylines' => 25,
                'reels' => 5,
                'release_date' => '2009-01-01',
                'rating' => 4.6,
                'plays_count' => 1200000,
                'features' => ['Progressive Jackpot', 'Free Spins', 'Bonus Wheel'],
                'bonus_features' => ['Mega Fortune Wheel', 'Progressive Jackpot'],
                'demo_url' => 'https://demo.netent.com/mega-fortune',
                'real_url' => 'https://casino.example.com/mega-fortune',
                'iframe_url' => 'https://games.netent.com/game/mega-fortune',
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => 'Mega Fortune - Прогрессивный джекпот',
                'meta_description' => 'Mega Fortune от NetEnt - роскошный слот с прогрессивным джекпотом и возможностью выиграть миллионы.',
            ],
            [
                'name' => 'Thunderstruck II',
                'slug' => 'thunderstruck-ii',
                'description' => 'Слот на тему скандинавской мифологии с множественными бонусными раундами и четырьмя уровнями бонусов.',
                'provider' => 'Microgaming',
                'theme' => 'Мифология',
                'rtp' => 96.65,
                'volatility' => 3.5,
                'min_bet' => 30,
                'max_bet' => 300000,
                'max_win' => 1500000,
                'paylines' => 243,
                'reels' => 5,
                'release_date' => '2010-01-01',
                'rating' => 4.8,
                'plays_count' => 1600000,
                'features' => ['Free Spins', 'Wildstorm Feature', 'Great Hall of Spins'],
                'bonus_features' => ['Valkyrie', 'Loki', 'Odin', 'Thor'],
                'demo_url' => 'https://demo.microgaming.com/thunderstruck-ii',
                'real_url' => 'https://casino.example.com/thunderstruck-ii',
                'iframe_url' => 'https://games.microgaming.com/game/thunderstruck-ii',
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => 'Thunderstruck II - Скандинавская мифология',
                'meta_description' => 'Thunderstruck II от Microgaming - слот на тему скандинавской мифологии с множественными бонусными раундами.',
            ],
            [
                'name' => 'Immortal Romance',
                'slug' => 'immortal-romance',
                'description' => 'Вампирская романтика с захватывающим сюжетом и высокими выигрышами. Темная и загадочная атмосфера.',
                'provider' => 'Microgaming',
                'theme' => 'Вампиры',
                'rtp' => 96.86,
                'volatility' => 4.0,
                'min_bet' => 30,
                'max_bet' => 300000,
                'max_win' => 1200000,
                'paylines' => 243,
                'reels' => 5,
                'release_date' => '2011-01-01',
                'rating' => 4.7,
                'plays_count' => 1400000,
                'features' => ['Free Spins', 'Wild Desire', 'Chamber of Spins'],
                'bonus_features' => ['Amber', 'Troy', 'Michael', 'Sarah'],
                'demo_url' => 'https://demo.microgaming.com/immortal-romance',
                'real_url' => 'https://casino.example.com/immortal-romance',
                'iframe_url' => 'https://games.microgaming.com/game/immortal-romance',
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => 'Immortal Romance - Вампирская романтика',
                'meta_description' => 'Immortal Romance от Microgaming - вампирская романтика с захватывающим сюжетом и высокими выигрышами.',
            ],
            [
                'name' => 'Wolf Gold',
                'slug' => 'wolf-gold',
                'description' => 'Дикий запад с волками и золотом. Слот с множественными бонусными функциями и высоким потенциалом выигрыша.',
                'provider' => 'Pragmatic Play',
                'theme' => 'Дикий запад',
                'rtp' => 96.01,
                'volatility' => 3.0,
                'min_bet' => 25,
                'max_bet' => 125000,
                'max_win' => 1000000,
                'paylines' => 25,
                'reels' => 5,
                'release_date' => '2017-01-01',
                'rating' => 4.5,
                'plays_count' => 1100000,
                'features' => ['Free Spins', 'Money Respin', 'Mega Symbols'],
                'bonus_features' => ['Money Respin Feature', 'Free Spins Feature'],
                'demo_url' => 'https://demo.pragmaticplay.com/wolf-gold',
                'real_url' => 'https://casino.example.com/wolf-gold',
                'iframe_url' => 'https://games.pragmaticplay.com/game/wolf-gold',
                'is_featured' => false,
                'is_active' => true,
                'meta_title' => 'Wolf Gold - Дикий запад с волками',
                'meta_description' => 'Wolf Gold от Pragmatic Play - слот на тему дикого запада с волками и множественными бонусными функциями.',
            ],
            [
                'name' => 'Sweet Bonanza',
                'slug' => 'sweet-bonanza',
                'description' => 'Сладкий слот с конфетами и фруктами. Безлинейный слот с множителями и бесплатными вращениями.',
                'provider' => 'Pragmatic Play',
                'theme' => 'Конфеты',
                'rtp' => 96.51,
                'volatility' => 3.5,
                'min_bet' => 20,
                'max_bet' => 100000,
                'max_win' => 800000,
                'paylines' => 0,
                'reels' => 6,
                'release_date' => '2019-01-01',
                'rating' => 4.6,
                'plays_count' => 900000,
                'features' => ['Free Spins', 'Multipliers', 'Tumble Feature'],
                'bonus_features' => ['Tumble Feature', 'Free Spins with Multipliers'],
                'demo_url' => 'https://demo.pragmaticplay.com/sweet-bonanza',
                'real_url' => 'https://casino.example.com/sweet-bonanza',
                'iframe_url' => 'https://games.pragmaticplay.com/game/sweet-bonanza',
                'is_featured' => false,
                'is_active' => true,
                'meta_title' => 'Sweet Bonanza - Сладкий слот с конфетами',
                'meta_description' => 'Sweet Bonanza от Pragmatic Play - сладкий слот с конфетами, множителями и бесплатными вращениями.',
            ],
            [
                'name' => 'Reactoonz',
                'slug' => 'reactoonz',
                'description' => 'Космические пришельцы в сеточном слоте. Инновационная механика с каскадными выигрышами и бонусными функциями.',
                'provider' => 'Play\'n GO',
                'theme' => 'Космос',
                'rtp' => 96.51,
                'volatility' => 4.0,
                'min_bet' => 20,
                'max_bet' => 100000,
                'max_win' => 1200000,
                'paylines' => 0,
                'reels' => 7,
                'release_date' => '2017-01-01',
                'rating' => 4.4,
                'plays_count' => 800000,
                'features' => ['Cascading Reels', 'Quantum Leap', 'Gargantoon'],
                'bonus_features' => ['Quantum Leap Feature', 'Gargantoon Feature'],
                'demo_url' => 'https://demo.playngo.com/reactoonz',
                'real_url' => 'https://casino.example.com/reactoonz',
                'iframe_url' => 'https://games.playngo.com/game/reactoonz',
                'is_featured' => false,
                'is_active' => true,
                'meta_title' => 'Reactoonz - Космические пришельцы',
                'meta_description' => 'Reactoonz от Play\'n GO - космические пришельцы в сеточном слоте с каскадными выигрышами.',
            ],
            [
                'name' => 'Dead or Alive 2',
                'slug' => 'dead-or-alive-2',
                'description' => 'Дикий запад с высоковолатильным геймплеем. Слот для любителей риска с огромными множителями.',
                'provider' => 'NetEnt',
                'theme' => 'Дикий запад',
                'rtp' => 96.82,
                'volatility' => 5.0,
                'min_bet' => 9,
                'max_bet' => 180000,
                'max_win' => 2000000,
                'paylines' => 9,
                'reels' => 5,
                'release_date' => '2019-01-01',
                'rating' => 4.3,
                'plays_count' => 700000,
                'features' => ['Free Spins', 'Sticky Wilds', 'Multipliers'],
                'bonus_features' => ['Sticky Wilds', 'Multiplier Feature'],
                'demo_url' => 'https://demo.netent.com/dead-or-alive-2',
                'real_url' => 'https://casino.example.com/dead-or-alive-2',
                'iframe_url' => 'https://games.netent.com/game/dead-or-alive-2',
                'is_featured' => false,
                'is_active' => true,
                'meta_title' => 'Dead or Alive 2 - Высоковолатильный запад',
                'meta_description' => 'Dead or Alive 2 от NetEnt - высоковолатильный слот на тему дикого запада с огромными множителями.',
            ],
        ];

        foreach ($slots as $slotData) {
            Slot::create($slotData);
        }
    }
}
