import axios from 'axios';
// import Echo from 'laravel-echo';
// import Pusher from 'pusher-js';

window.axios = axios;

window.axios.defaults.headers.common['X-Requested-With'] = 'XMLHttpRequest';

const token = document.head.querySelector('meta[name="csrf-token"]');
if (token) {
    window.axios.defaults.headers.common['X-CSRF-TOKEN'] = token.content;
} else {
    console.error('CSRF token not found: https://laravel.com/docs/csrf#csrf-x-csrf-token');
}

window.axios.defaults.baseURL = '/api/v1';
window.axios.defaults.withCredentials = true; // Включаем отправку куки

// WebSocket configuration - DISABLED
// window.Pusher = Pusher;

// Инициализация Echo для WebSocket - DISABLED
// window.Echo = new Echo({
//     broadcaster: 'pusher',
//     key: 'local-key',
//     cluster: 'local',
//     wsHost: window.location.hostname,
//     wsPort: 6001,
//     forceTLS: false,
//     disableStats: true,
//     enabledTransports: ['ws'],
//     auth: {
//         headers: {
//             'X-CSRF-TOKEN': token ? token.content : '',
//             'Authorization': `Bearer ${localStorage.getItem('token') || ''}`
//         }
//     }
// });

console.log('✅ WebSocket disabled - using polling instead');

// Возвращаем Bearer токен для совместимости с остальным приложением
window.axios.interceptors.request.use(function (config) {
    const token = localStorage.getItem('token');
    if (token) {
        config.headers.Authorization = `Bearer ${token}`;
    }
    return config;
}, function (error) {
    return Promise.reject(error);
});

window.axios.interceptors.response.use(function (response) {
    return response;
}, function (error) {
    if (error.response?.status === 401) {
        localStorage.removeItem('token');
        localStorage.removeItem('user');
        
        window.dispatchEvent(new CustomEvent('auth:logout'));
        
        window.location.href = '/';
    }
    return Promise.reject(error);
});

window.safeJsonParse = function(data, defaultValue = null) {
    if (!data || data === 'undefined' || data === 'null') {
        return defaultValue;
    }
    try {
        const result = JSON.parse(data);
        return result;
    } catch (error) {
        console.error('safeJsonParse: Error parsing JSON:', error, 'Data:', data, 'Type:', typeof data);
        return defaultValue;
    }
};

window.logout = async function() {
    try {
        const token = localStorage.getItem('token');
        
        if (token) {
            await window.axios.post('/logout', {}, {
                headers: { 'Authorization': `Bearer ${token}` }
            });
        }
    } catch (error) {
        console.error('Logout error:', error);
    } finally {
        localStorage.removeItem('token');
        localStorage.removeItem('user');
        
        window.dispatchEvent(new CustomEvent('auth:logout'));
        
        window.location.href = '/';
    }
};
