<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\SitemapController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// Главная страница
Route::get('/', function () {
    return view('welcome');
});

// Login route for compatibility
Route::get('/login', function () {
    return view('welcome');
});

// Sitemap
Route::get('/sitemap.xml', [SitemapController::class, 'index']);

// SPA Routes - все остальные роуты возвращают главную страницу для Vue Router
Route::get('/{any}', function () {
    return view('welcome');
})->where('any', '^(?!api).*$');
