# Запуск Laravel сервера для мобильного доступа
Write-Host "🚀 Запуск Laravel сервера для локальной сети..." -ForegroundColor Green
Write-Host ""

# Получаем IP адрес
$localIP = (Get-NetIPAddress -AddressFamily IPv4 -InterfaceAlias "Wi-Fi" | Where-Object {$_.IPAddress -notlike "169.254.*"}).IPAddress
if (-not $localIP) {
    $localIP = (Get-NetIPAddress -AddressFamily IPv4 -InterfaceAlias "Ethernet" | Where-Object {$_.IPAddress -notlike "169.254.*"}).IPAddress
}

Write-Host "🌐 Ваш IP адрес: $localIP" -ForegroundColor Cyan
Write-Host ""
Write-Host "📱 URL для мобильного доступа:" -ForegroundColor White
Write-Host "   http://$localIP:8000" -ForegroundColor Green
Write-Host ""
Write-Host "💡 Убедитесь что:" -ForegroundColor Yellow
Write-Host "   • Телефон в той же WiFi сети" -ForegroundColor White
Write-Host "   • Файрвол не блокирует порт 8000" -ForegroundColor White
Write-Host ""

# Запускаем Laravel сервер
Write-Host "🔄 Запуск сервера..." -ForegroundColor Yellow
php artisan serve --host=0.0.0.0 --port=8000 